/*
 * Decompiled with CFR 0.152.
 */
package util;

import Data_Structures.Structures.List;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import util.interfaces.SerialImageB;

public class ImageUtil {
    public static void saveImage(SerialImageB obj, String name) {
        ImageUtil.saveImage(obj.serializeImage(), name);
    }

    public static void saveImage(BufferedImage image, String name) {
        try {
            File outputfile;
            String imageType;
            int dotIndex = name.length() - 4;
            if (name.charAt(dotIndex) == '.') {
                imageType = name.substring(dotIndex + 1).toUpperCase();
                outputfile = new File(name);
            } else {
                imageType = "PNG";
                outputfile = new File(String.valueOf(name) + "." + imageType.toLowerCase());
            }
            ImageIO.write((RenderedImage)image, imageType, outputfile);
        }
        catch (IOException e) {
            System.out.println("saveImage function has failed in the Brenderer");
        }
    }

    private BufferedImage toCompatibleImage(BufferedImage image) {
        GraphicsConfiguration gfx_config = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (image.getColorModel().equals(gfx_config.getColorModel())) {
            return image;
        }
        BufferedImage new_image = gfx_config.createCompatibleImage(image.getWidth(), image.getHeight(), image.getTransparency());
        Graphics2D g2d = (Graphics2D)new_image.getGraphics();
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return new_image;
    }

    public static void floodFill(BufferedImage sprite, int x_start, int y_start, Color color_2) {
        int c1 = sprite.getRGB(x_start, y_start);
        int c2 = color_2.getRGB();
        List<Integer> S = new List<Integer>();
        S.push(x_start);
        S.push(y_start);
        while (!S.isEmpty()) {
            int c;
            int y = (Integer)S.pop();
            int x = (Integer)S.pop();
            try {
                c = sprite.getRGB(x, y);
            }
            catch (Exception e) {
                continue;
            }
            if (c != c1) continue;
            sprite.setRGB(x, y, c2);
            S.push(x);
            S.push(y + 1);
            S.push(x);
            S.push(y - 1);
            S.push(x - 1);
            S.push(y);
            S.push(x + 1);
            S.push(y);
        }
    }

    public static void enableAllAntialiasing(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }
}

